function test_suite = testTriu %#ok<*STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
p = polysym.empty;
assertTrue(isempty(p.triu))

function testDefault
p = polysym;
assertEqual(p.triu,p)

function testMultipleChars
p = polysym('xyz');
assertEqual(p.triu,p)

function testNoSecondTerm
M = randi(100,3);
p = polysym(M);
assertEqual(p.triu,polysym(triu(p)))

function testPositiveDiagonal
M = randi(100,5);
k = 2;
p = polysym(M);
assertEqual(triu(p,k),polysym(triu(p,k)))

function testNegativeDiagonal
M = randi(100,5);
k = -2;
p = polysym(M);
assertEqual(triu(p,k),polysym(triu(p,k)))